from django.urls import path
from . import views

app_name = 'appointments'

urlpatterns = [
    # Appointment views
    path('', views.AppointmentListView.as_view(), name='appointment-list'),
    path('create/', views.AppointmentCreateView.as_view(), name='appointment-create'),
    path('<int:pk>/', views.AppointmentDetailView.as_view(), name='appointment-detail'),
    path('<int:pk>/update/', views.AppointmentUpdateView.as_view(), name='appointment-update'),
    path('<int:pk>/delete/', views.AppointmentDeleteView.as_view(), name='appointment-delete'),
    path('<int:pk>/cancel/', views.appointment_cancel, name='appointment-cancel'),
    path('<int:pk>/complete/', views.appointment_complete, name='appointment-complete'),
    
    # Service views
    path('services/', views.ServiceListView.as_view(), name='service-list'),
    path('services/create/', views.ServiceCreateView.as_view(), name='service-create'),
    path('services/<int:pk>/', views.ServiceDetailView.as_view(), name='service-detail'),
    path('services/<int:pk>/update/', views.ServiceUpdateView.as_view(), name='service-update'),
    path('services/<int:pk>/delete/', views.ServiceDeleteView.as_view(), name='service-delete'),
    
    # Staff member views
    path('staff/', views.StaffListView.as_view(), name='staff-list'),
    path('staff/create/', views.StaffCreateView.as_view(), name='staff-create'),
    path('staff/<int:pk>/', views.StaffDetailView.as_view(), name='staff-detail'),
    path('staff/<int:pk>/update/', views.StaffUpdateView.as_view(), name='staff-update'),
    path('staff/<int:pk>/delete/', views.StaffDeleteView.as_view(), name='staff-delete'),
    
    # Calendar view
    path('calendar/', views.CalendarView.as_view(), name='calendar-view'),
    
    # Note management
    path('<int:pk>/add-note/', views.add_appointment_note, name='add-appointment-note'),
    path('notes/<int:pk>/delete/', views.delete_appointment_note, name='delete-appointment-note'),
    
    # API endpoints
    path('api/available-slots/', views.AvailableSlotsAPIView.as_view(), name='api-available-slots'),
    path('api/appointments/', views.AppointmentListAPIView.as_view(), name='api-appointment-list'),
    path('api/appointments/<int:pk>/', views.AppointmentDetailAPIView.as_view(), name='api-appointment-detail'),
]
